<?php

namespace App/Model/LessonReview;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonReviews extends Model 
{

    protected $table = 'lesson_reviews';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lesson_id', 'rate', 'comment');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

}