<?php

namespace App/Model/Download;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Download extends Model 
{

    protected $table = 'downloads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'course_id');

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

}