<?php

namespace App/Model/CourseFeature;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourseFeature extends Model 
{

    protected $table = 'course_features';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('course_id', 'feature', 'status');

    public function courses()
    {
        return $this->belongsToMany('Course', 'course_id');
    }

}