<?php

namespace App\Models\QuizStudentQuestion;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuizStudentQuestion extends Eloquent {

	protected $table = 'quiz_student_question';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quiz_student_id', 'question_id', 'status', 'is_correct', 'answer_id');

	public function quizStudent()
	{
		return $this->belongsTo('QuizStudents', 'quiz_student_id');
	}

	public function questions()
	{
		return $this->belongsTo('QuizQuestion', 'question_id');
	}

}