<?php

namespace App/Model/FlashCard;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FlashCard extends Eloquent {

	protected $table = 'flashcards';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lesson_id', 'english_word', 'arabic_word', 'pronuciation', 'status');

	public function lesson()
	{
		return $this->belongsTo('Lesson', 'lesson_id');
	}

}