<?php

namespace App/Model/Favourite;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Favourite extends Eloquent {

	protected $table = 'favourites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('student_id', 'favouritable_id', 'favouritable_type');

	public function student()
	{
		return $this->belongsTo('Student', 'student_id');
	}

}