<?php

namespace App/Model/Faqs;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Faqs extends Eloquent {

	protected $table = 'faqs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('question', 'answer', 'faq_category_id');

	public function faqCategories()
	{
		return $this->belongsTo('FaqCategories', 'faq_category_id');
	}

}