<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('resource_id')->unsigned();
			$table->bigInteger('utilization_id')->unsigned();
			$table->enum('accounting_method', array('hourly', 'monthly'));
			$table->integer('number_of_paid_hours')->default('24');
			$table->float('price');
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}