<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVideosTable extends Migration {

	public function up()
	{
		Schema::create('videos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('channel_id')->unsigned();
			$table->string('title', 255);
			$table->text('description');
			$table->string('preview_image', 255);
			$table->string('poster_image', 255);
			$table->string('path', 255);
			$table->string('file_name', 255);
			$table->string('source', 255)->nullable();
			$table->integer('duration');
			$table->timestamp('published_date');
			$table->enum('accessibility', array('free', 'subscription', 'ppv'));
			$table->integer('ppv_price')->nullable();
			$table->boolean('is_visible')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('videos');
	}
}