<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaveTypeTable extends Migration {

	public function up()
	{
		Schema::create('leave_type', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('code', 10)->unique();
			$table->string('description');
			$table->tinyInteger('active');
			$table->tinyInteger('deduct_payroll');
			$table->string('calc_prorate');
			$table->tinyInteger('include_holiday');
			$table->tinyInteger('is_medical');
			$table->tinyInteger('allow_bf');
			$table->tinyInteger('max_bf');
			$table->integer('notice_day');
			$table->enum('balance_type', array('MONTH', 'YEAR'));
			$table->char('deduct_next_year_leave_type', 10);
		});
	}

	public function down()
	{
		Schema::drop('leave_type');
	}
}