<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCorePositionTable extends Migration {

	public function up()
	{
		Schema::create('core_position', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('code', 10)->unique();
			$table->string('description');
			$table->tinyInteger('active');
			$table->char('key_by', 10);
			$table->char('modified_by', 10);
			$table->datetime('modified_datetime');
		});
	}

	public function down()
	{
		Schema::drop('core_position');
	}
}