<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RfLease extends Eloquent {

	protected $table = 'rf_leases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('start_date', 'end_date', 'handover_date', 'tenant_type', 'rf_user_id', 'contract_number', 'deal_owner_id', 'rental_type', 'rental_total_amount', 'fit_out_status_id', 'payment_schedule_id', 'lease_escalations_type_id', 'security_deposit_amount', 'security_deposit_due_date', 'terms_conditions', 'status_id', 'is_sub_lease', 'is_terms', 'source', 'updated_by', 'created_by');

	public function lease_escalations()
	{
		return $this->hasMany('RFTenant\Models\RfLeaseEscalation');
	}

	public function subLeases()
	{
		return $this->hasMany('RFTenant\Models\RfSubLease');
	}

	public function additional_fees_leases()
	{
		return $this->hasMany('RFTenant\Models\RfAdditionalFeesLease');
	}

	public function additional_fees()
	{
		return $this->belongsToMany('RFTenant\Models\RfAdditionalFees');
	}

	public function units()
	{
		return $this->belongsToMany('RFTenant\Models\RfUnits');
	}

	public function fit_out_status()
	{
		return $this->belongsTo('RFTenant\Models\RfLeaseSpecification', 'fit_out_status_id');
	}

	public function payment_schedule()
	{
		return $this->belongsTo('RFTenant\Models\RfLeaseSpecification', 'payment_schedule_id');
	}

	public function lease_escalations_type()
	{
		return $this->belongsTo('RFTenant\Models\RfLeaseSpecification', 'lease_escalations_type_id');
	}

}