<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfUnitMarketplacesTable extends Migration {

	public function up()
	{
		Schema::create('rf_unit_marketplaces', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array(''sale'', ''rent''));
			$table->enum('amount_type', array(''total'', ''sqm''));
			$table->decimal('price', 12,2)->default('0');
			$table->float('tax_rate')->default('0');
			$table->decimal('deposite', 12,2)->default('0');
			$table->bigInteger('rf_unit_id')->unsigned();
			$table->integer('booking_status_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_unit_marketplaces');
	}
}