<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfBuildingsTable extends Migration {

	public function up()
	{
		Schema::create('rf_buildings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->integer('rf_community_id')->unsigned();
			$table->integer('no_floors')->default('0');
			$table->date('year_build')->nullable();
			$table->json('map')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rf_buildings');
	}
}