<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfCommunitiesTable extends Migration {

	public function up()
	{
		Schema::create('rf_communities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->integer('country_id')->unsigned();
			$table->integer('currency_id')->unsigned();
			$table->integer('district_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->json('map');
			$table->boolean('is_active')->default(1);
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rf_communities');
	}
}