<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockMovement extends Model 
{

    protected $table = 'stock_movements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->hasOne('Product');
    }

    public function transaction()
    {
        return $this->belongsTo('StockTransactions');
    }

    public function warehouse()
    {
        return $this->hasOne('Warehouse');
    }

}