<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->hasOne('Category');
    }

    public function user()
    {
        return $this->hasOne('User');
    }

    public function customer()
    {
        return $this->hasOne('Customer');
    }

    public function stock()
    {
        return $this->hasOne('Stock');
    }

    public function barcodes()
    {
        return $this->hasMany('ProductBarcodes');
    }

}