<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLancamentosTable extends Migration {

	public function up()
	{
		Schema::create('lancamentos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('presentes_id')->unsigned()->nullable();
			$table->integer('saques_id')->unsigned()->nullable();
			$table->float('valor');
			$table->string('descricao', 254)->nullable();
			$table->string('operacao', 1)->nullable();
			$table->string('confirmado', 1);
			$table->string('liberado', 1);
			$table->enum('categoria', array('evento', 'cerimonial', 'administrativo'));
			$table->enum('tipo', array('taxa', 'extra', 'saque'));
			$table->datetime('dtregistrado');
		});
	}

	public function down()
	{
		Schema::drop('lancamentos');
	}
}