<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventosTable extends Migration {

	public function up()
	{
		Schema::create('eventos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('tiposeventos_id')->unsigned();
			$table->integer('cerimoniais_id')->unsigned()->nullable();
			$table->integer('templates_id')->unsigned()->nullable();
			$table->string('responsavel', 254)->nullable();
			$table->string('responsavelemail', 254);
			$table->string('responsaveltelefone', 20)->nullable();
			$table->string('senha', 254)->nullable();
			$table->float('taxaservico');
			$table->text('contratoaceito')->nullable();
			$table->date('dtevento')->nullable();
			$table->datetime('dtalterado');
			$table->datetime('dtregistrado');
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('eventos');
	}
}