<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCerimoniaisTable extends Migration {

	public function up()
	{
		Schema::create('cerimoniais', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('tipopessoa', array('juridica', 'fisica'));
			$table->string('cadastronacional', 30)->nullable();
			$table->string('nome', 254);
			$table->string('contato', 254)->nullable();
			$table->string('razaosocial', 254)->nullable();
			$table->string('email', 254);
			$table->string('senha', 30);
			$table->string('telefone1', 15)->nullable();
			$table->string('telefone2', 15)->nullable();
			$table->string('celular', 15)->nullable();
			$table->string('pagseguro', 254)->nullable();
			$table->string('cidade', 254)->nullable();
			$table->string('estado', 2)->nullable();
			$table->string('endereco', 254)->nullable();
			$table->string('cep', 15)->nullable();
			$table->string('site', 254)->nullable();
			$table->float('taxaparticipacao');
			$table->text('contratoaceito')->nullable();
			$table->datetime('dtalterado');
			$table->datetime('dtregistrado');
		});
	}

	public function down()
	{
		Schema::drop('cerimoniais');
	}
}