<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('SrNo')->unsigned();
			$table->bigInteger('entryNo')->unsigned();
			$table->integer('cardUID')->unsigned();
			$table->date('date');
			$table->time('time');
			$table->string('userName', 20);
			$table->float('crDr', 20,2);
			$table->char('crDrType', 10);
			$table->float('balance', 20,2);
			$table->string('seriesNo', 20);
			$table->string('storeId', 20);
			$table->integer('machineId')->unsigned();
			$table->bigInteger('quantityInMl')->unsigned();
			$table->string('buttonNo', 10);
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}