<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('cust_name', 255);
			$table->string('phone_number', 20);
			$table->string('location', 255);
			$table->integer('cardUID')->unsigned();
			$table->boolean('status')->default(1);
			$table->string('created_by', 50)->nullable();
			$table->string('updated_by', 50)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}