<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCulturalEntitySubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('cultural_entity_subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('cultural_entity_id')->unsigned();
			$table->integer('subscription_plan_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('is_active')->default(true);
			$table->integer('usage_percent')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cultural_entity_subscriptions');
	}
}