<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CulturalEntity extends Eloquent {

	protected $table = 'cultural_entity';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function district()
	{
		return $this->belongsTo('District', 'district_id');
	}

	public function culturalEntityType()
	{
		return $this->belongsTo('CulturalEntityType', 'cultural_entity_type_id');
	}

}