<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDistrictTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('district_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->integer('district_id')->unique()->unsigned();
			$table->string('locale', 2)->unique()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('district_translations');
	}
}