<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionPlansTable extends Migration {

	public function up()
	{
		Schema::create('subscription_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('plan_type')->nullable();
			$table->string('name')->unique()->nullable();
			$table->decimal('price')->nullable();
			$table->string('duration')->nullable();
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('subscription_plans');
	}
}