<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountryTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('country_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('nationality')->nullable();
			$table->string('locale', 2)->unique()->nullable();
			$table->integer('country_id')->unique()->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('country_translations');
	}
}