<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 6)->nullable();
			$table->string('iso_code', 2)->nullable();
			$table->boolean('is_active')->default(true);
			$table->boolean('is_default')->default(false);
			$table->string('flag');
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}