<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuthenticatableOtpsTable extends Migration {

	public function up()
	{
		Schema::create('authenticatable_otps', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 6);
			$table->string('email')->nullable();
			$table->string('phone', 20)->nullable();
			$table->boolean('is_active')->default(true);
			$table->morphs('authenticatable')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('authenticatable_otps');
	}
}