<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCulturalEntityTable extends Migration {

	public function up()
	{
		Schema::create('cultural_entity', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 20)->nullable();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->string('temp_password')->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('district_id')->unsigned();
			$table->boolean('is_active')->default(true);
			$table->string('address')->nullable();
			$table->string('phone', 20)->nullable();
			$table->integer('cultural_entity_type_id');
			$table->string('logo');
			$table->string('lat')->nullable();
			$table->string('long')->nullable();
			$table->string('licence_number')->nullable();
			$table->string('license_document');
			$table->string('location')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cultural_entity');
	}
}