<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCityTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('city_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('locale', 2)->unique()->nullable();
			$table->integer('city_id')->unique()->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('city_translations');
	}
}