<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabProductCustomizationDetailsTable extends Migration {

	public function up()
	{
		Schema::create('tabProductCustomizationDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('add_on');
			$table->string('label');
			$table->string('parent_add_on')->nullable();
			$table->integer('min_select');
			$table->integer('max_select');
			$table->decimal('extra_price', 8,2)->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabProductCustomizationDetails');
	}
}