<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SpareItem extends Eloquent {

	protected $table = 'spare_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'item_name', 'amount', 'unit_id', 'notes');

	public function unit()
	{
		return $this->belongsTo('Unit', 'unit_id');
	}

	public function order()
	{
		return $this->belongsTo('SpareOrder', 'order_id');
	}

}