<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PeriodicMaintenance extends Eloquent {

	protected $table = 'periodic_maintenance';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'region_id', 'site_id', 'status');

	public function region()
	{
		return $this->belongsTo('Region', 'region_id');
	}

	public function site()
	{
		return $this->belongsTo('Site', 'site_id');
	}

}