<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AchievementCertificate extends Model 
{

    protected $table = 'achievement_certificate';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('region_id', 'date_from', 'date_to', 'total', 'date', 'status');

    public function region()
    {
        return $this->belongsTo('Region', 'region_id');
    }

}