<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('denay', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifcation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->foreign('sec_id')->references('id')->on('user_section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recommend', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recommend', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activity')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('userevents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('userevents', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('denay', function(Blueprint $table) {
			$table->dropForeign('denay_user_id_foreign');
		});
		Schema::table('notifcation', function(Blueprint $table) {
			$table->dropForeign('notifcation_user_id_foreign');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->dropForeign('permission_user_id_foreign');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->dropForeign('permission_sec_id_foreign');
		});
		Schema::table('recommend', function(Blueprint $table) {
			$table->dropForeign('recommend_cat_id_foreign');
		});
		Schema::table('recommend', function(Blueprint $table) {
			$table->dropForeign('recommend_user_id_foreign');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->dropForeign('volunteer_activity_id_foreign');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->dropForeign('volunteer_user_id_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_user_id_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_cat_id_foreign');
		});
		Schema::table('userevents', function(Blueprint $table) {
			$table->dropForeign('userevents_user_id_foreign');
		});
		Schema::table('userevents', function(Blueprint $table) {
			$table->dropForeign('userevents_event_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_user_id_foreign');
		});
	}
}