<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->string('email', 100);
			$table->string('password', 50);
			$table->enum('role', array('admin', 'teacher', 'librarian', 'supervisor', 'student', 'parent'));
			$table->date('hire_date');
			$table->string('ID_documents')->nullable();
			$table->string('phone_number');
			$table->date('birth_date');
			$table->enum('gender', array('male', 'female'));
			$table->text('address');
			$table->timestamps();
			$table->tinyInteger('salary')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}