<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivityParticipantTable extends Migration {

	public function up()
	{
		Schema::create('Activity_Participant', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('activity_id')->unsigned();
			$table->bigInteger('Student_id')->unsigned();
			$table->enum('payment_status', array('pending', 'paid', 'cancelled', 'free_activity'));
			$table->boolean('attendance')->default(false);
			$table->enum('payment_method', array('cash', 'by_parent', 'by_app'))->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Activity_Participant');
	}
}