<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassSessionTable extends Migration {

	public function up()
	{
		Schema::create('Class_Session', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('treacher_id')->unsigned();
			$table->bigInteger('class_id')->unsigned();
			$table->bigInteger('subject_id')->unsigned();
			$table->enum('session_day', array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'));
			$table->time('start_time');
			$table->time('end_time');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Class_Session');
	}
}