<?php

class Mark extends Eloquent {

	protected $table = 'Mark';
	public $timestamps = true;
	protected $fillable = array('student_id', 'teacher_id', 'exam_type', 'score', 'max_score', 'date', 'teacher_note');
	protected $visible = array('student_id', 'teacher_id', 'exam_type', 'score', 'max_score', 'date', 'teacher_note');

	public function student()
	{
		return $this->belongsTo('Student', 'student_id');
	}

	public function subject()
	{
		return $this->belongsTo('Subject', 'subject_id');
	}

	public function teacher()
	{
		return $this->belongsTo('Teacher', 'teacher_id');
	}

}