<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationalContentTable extends Migration {

	public function up()
	{
		Schema::create('Educational_Content', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('teacher_id')->unsigned();
			$table->bigInteger('class_id')->unsigned();
			$table->string('title', 50)->nullable();
			$table->text('description')->nullable();
			$table->enum('content_type', array('video', 'pdf', 'link', 'image', 'text', 'quiz'));
			$table->string('file_url', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Educational_Content');
	}
}