<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitieTable extends Migration {

	public function up()
	{
		Schema::create('Activitie', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Title', 255);
			$table->bigInteger('class_id')->unsigned();
			$table->bigInteger('education_level_id')->unsigned()->nullable();
			$table->text('Description');
			$table->enum('activity_type', array('trip', 'sports', 'art', 'competition', 'course', 'other'));
			$table->date('date');
			$table->string('location', 255)->nullable();
			$table->enum('target_group', array('all', 'class', 'stage', 'specific'));
			$table->boolean('is_paid');
			$table->integer('cost')->nullable();
			$table->integer('seats_limit')->nullable();
			$table->date('registration_deadline');
			$table->boolean('is_open');
			$table->json('gallery_urls')->nullable();
			$table->json('required_skills')->nullable();
			$table->boolean('auto_filter_participants');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Activitie');
	}
}