<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Loan extends Eloquent {

	protected $table = 'loans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Transactions()
	{
		return $this->hasMany('Transaction');
	}

	public function Customer()
	{
		return $this->belongsTo('Customer');
	}

	public function LoanType()
	{
		return $this->belongsTo('LoanType');
	}

}