<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leaders', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Labs_Products', function(Blueprint $table) {
			$table->foreign('Product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Labs_Products', function(Blueprint $table) {
			$table->foreign('Labs_id')->references('id')->on('labs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('FSE', function(Blueprint $table) {
			$table->foreign('Leader_id')->references('id')->on('leaders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('branche')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('leaders', function(Blueprint $table) {
			$table->dropForeign('leaders_area_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_lab_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_area_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_category_id_foreign');
		});
		Schema::table('Labs_Products', function(Blueprint $table) {
			$table->dropForeign('Labs_Products_Product_id_foreign');
		});
		Schema::table('Labs_Products', function(Blueprint $table) {
			$table->dropForeign('Labs_Products_Labs_id_foreign');
		});
		Schema::table('FSE', function(Blueprint $table) {
			$table->dropForeign('FSE_Leader_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_lab_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_branche_foreign');
		});
	}
}