<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HostingCompany extends Model 
{

    protected $table = 'hosting_company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_name', 'password');

    public function servers()
    {
        return $this->hasMany('Server', 'hosting_id');
    }

}