<?php

namespace App\Models;

class Marketer extends Eloquent {

	protected $table = 'marketers';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone');

	public function users()
	{
		return $this->hasMany('App\Models\User');
	}

	public function commissions()
	{
		return $this->morphMany('App\Modules\Commission\Entities\Commission', 'commissionable');
	}

}