<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('merchants')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('installment_id')->references('id')->on('installments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('transaction_id')->references('id')->on('transactions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('installment_id')->references('id')->on('installments')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_marketer_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_installment_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_transaction_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_installment_id_foreign');
		});
	}
}