<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('phone');
			$table->text('address');
			$table->string('email');
			$table->integer('bank_id');
			$table->string('verfication_code')->nullable();
			$table->double('monthly_salary_amount');
			$table->double('monthly_commitments_amount');
			$table->double('Insurance_value');
			$table->integer('marketer_id')->unsigned()->nullable();
			$table->string('forget_code')->nullable();
			$table->date('verfication_code_expiration_date')->nullable();
			$table->string('offers_letter_file')->nullable();
			$table->string('expected_funding')->default('0.0');
			$table->boolean('is_registerd_by_marketer')->default(0);
			$table->timestamps();
			$table->boolean('ability_to_notify')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}