<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentsTable extends Migration {

	public function up()
	{
		Schema::create('installments', function(Blueprint $table) {
			$table->increments('id');
			$table->date('installment_date');
			$table->date('payment_date')->nullable();
			$table->double('amount');
			$table->integer('transaction_id');
			$table->enum('status', array(''));
			$table->timestamps();
			$table->double('punish_of_delay')->default('0.0');
		});
	}

	public function down()
	{
		Schema::drop('installments');
	}
}