<?php

namespace App\Modes\Disorders;

class Disorders extends Eloquent {

	protected $table = 'disorders';
	public $timestamps = true;

	public function cases()
	{
		return $this->hasMany('CaseDisorder', 'disorder_id');
	}

	public function links()
	{
		return $this->hasMany('Links', 'disorder_id');
	}

	public function documents()
	{
		return $this->hasMany('Document', 'countable_id');
	}

	public function symptoms()
	{
		return $this->hasMany('DisorderSymptoms', 'disorder_id');
	}

}